﻿//////////////////////////////////////////////
// FontManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkWinUi
{
	class System ;
}

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "Font.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <string>
#include <unordered_map>

/// Class ------------------------------------

namespace nkWinUi
{
	class DLL_WINUI_EXPORT FontManager final : public nkCommon::MaybeSingletonClass<FontManager>
	{		
		public :

			// Getters
			Font* getDefaultFont () const ;
			System* getSystem () const ;
		
			// Memory management
			Font* createOrRetrieve (nkMemory::StringView name) ;
			Font* record (nkMemory::StringView name, nkMemory::UniquePtr<Font> resource) ;
			Font* get (nkMemory::StringView name) const ;
			Font* getByIndex (unsigned int index) const ;
			void rename (nkMemory::StringView oldName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;
			nkMemory::UniquePtr<Font> relinquish (nkMemory::StringView name) ;

		private :

			// Functions
			// Constructor, destructor
			FontManager (bool isSingleton) noexcept ;
			FontManager (System* parentSystem) noexcept ;
			FontManager (const FontManager&) = delete ;

			// Operators
			FontManager& operator= (const FontManager&) = delete ;

		private :

			// Attributes
			// Memory
			std::unordered_map<std::string, nkMemory::UniquePtr<Font>> _memory ;
			nkMemory::UniquePtr<Font> _defaultFont ;

			System* _system ;

		private :

			friend class nkCommon::MaybeSingletonClass<FontManager> ;
			friend class System ;
	} ;
}